#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

long long brojPreticanja(double vreme, vector<pair<int, int>>& trkaci) {
    long long brojac = 0;
    for (int i = 0; i < trkaci.size(); ++i) {
        for (int j = i + 1; j < trkaci.size(); ++j) {
            if ((trkaci[j].first - trkaci[i].first) <= vreme * (trkaci[i].second - trkaci[j].second)) {
                brojac++;
            }
        }
    }
    return brojac;
}

double nadjiKtoPreticanje(int N, int K, vector<pair<int, int>>& trkaci) {
    double donja = 0, gornja = 1e18;
    while (gornja - donja > 1e-6) {
        double sredina = donja + (gornja - donja) / 2;
        if (brojPreticanja(sredina, trkaci) >= K) {
            gornja = sredina;
        } else {
            donja = sredina;
        }
    }
    return gornja;
}

int main() {
    int N, K;
    cin >> N >> K;
    vector<pair<int, int>> trkaci(N);

    for (int i = 0; i < N; ++i) {
        cin >> trkaci[i].first >> trkaci[i].second;
    }

    double rezultat = nadjiKtoPreticanje(N, K, trkaci);
    cout.precision(9);
    cout << rezultat << endl;

    return 0;
}